//Design Zener Shunt-Voltage regulator
//Windows 10
//Scilab 6.0.0

clc;
clear;
close;

Vo=10       //in volts
Vinmin=20      //lowercase Vin in volts
Vinmax=30      //uppercase Vin in volts
Ilmin=30*10^-3       //lowercase Il in volts
Ilmax=50*10^-3       //uppercase Il in volts
Izmin=20*10^-3         //lowercase Iz in milli Ampere
Izmax=40*10^-3         //uppercase Iz in milli Ampere
Vz=Vo
Pz=Vz*Izmax
mprintf('Pz:%.2f W',Pz)
//Pz=0.4W,Hence a 0.5Z 10 zener can be selected
Rlmin=(Vo/Ilmax)
Rlmax=(Vo/Ilmin)
Rmax=((Vinmax-Vo)/(Ilmin+Izmax))
Rmin=((Vinmin-Vo)/(Ilmax+Izmin))
R=(Rmax+Rmin)/2
mprintf('\nRlmin:%d ohms',Rlmin)
mprintf('\nRlmax:%d ohms',Rlmax)
mprintf('\nRmax:%d ohms',Rmax)
mprintf('\nRmin:%d ohms',Rmin)
mprintf('\nR:%d ohms',R)
